<?php // BEGIN PHP
$websitekey=basename(__DIR__); if (empty($websitepagefile)) $websitepagefile=__FILE__;
if (! defined('USEDOLIBARRSERVER') && ! defined('USEDOLIBARREDITOR')) { require_once './master.inc.php'; } // Not already loaded
require_once DOL_DOCUMENT_ROOT.'/core/lib/website.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/website.inc.php';
ob_start();
// END PHP ?>
<html lang="en">
<head>
<title>Generic page</title>
<meta charset="utf-8">
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="robots" content="index, follow" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="keywords" content="My generic page" />
<meta name="title" content="Generic page" />
<meta name="description" content="Generic page or my personal Blog" />
<meta name="generator" content="Dolibarr 11.0.0-alpha (https://www.dolibarr.org)" />
<meta name="dolibarr:pageid" content="379" />
<link href="/generic.php" rel="canonical" />
<!-- Include link to CSS file -->
<link rel="stylesheet" href="styles.css.php?website=<?php echo $websitekey; ?>" type="text/css" />
<!-- Include HTML header from common file -->
<?php print preg_replace('/<\/?html>/ims', '', file_get_contents(DOL_DATA_ROOT."/website/".$websitekey."/htmlheader.html")); ?>
<!-- Include HTML header from page header block -->

</head>
<!-- File generated by Dolibarr website module editor -->
<body id="bodywebsite" class="bodywebsite bodywebpage-generic">
	
<!-- Wrapper -->
<div id="wrapper">

	<!-- Header -->
		<header id="header">
			<h1>Another page</h1>
			<p>Ipsum dolor sit amet nullam</p>
		</header>

    <!-- Menu -->
    <?php includeContainer('menu'); ?>

	<!-- Main -->
	<div id="main">

		<!-- Content -->
		<section id="content" class="main" contenteditable="true">
			<span class="image main"><img src="medias/image/template-stellar/pic01.jpg" alt="" /></span>
			<h2>Magna feugiat lorem</h2>
			<p>Donec eget ex magna. Interdum et malesuada fames ac ante ipsum primis in faucibus. Pellentesque venenatis dolor imperdiet dolor mattis sagittis. Praesent rutrum sem diam, vitae egestas enim auctor sit amet. Pellentesque leo mauris, consectetur id ipsum sit amet, fergiat. Pellentesque in mi eu massa lacinia malesuada et a elit. Donec urna ex, lacinia in purus ac, pretium pulvinar mauris. Curabitur sapien risus, commodo eget turpis at, elementum convallis fames ac ante ipsum primis in faucibus.</p>
			<p>Pellentesque venenatis dolor imperdiet dolor mattis sagittis. Praesent rutrum sem diam, vitae egestas enim auctor sit amet.</p>
			<h2>Tempus veroeros</h2>
			<p>Cep risus aliquam gravida cep ut lacus amet. Adipiscing faucibus nunc placerat. Tempus adipiscing turpis non blandit accumsan eget lacinia nunc integer interdum amet aliquam ut orci non col ut ut praesent.</p>
		</section>

        <!-- Blog list -->
        <section id="sectionnews" contenteditable="true" class="main section-50 section-md-50 section-md-bottom-50">
			<h2>Latest Blog posts</h2>
            <div class="center">
            <?php 
            $keyword = 'blog';
            $weblangs->loadLangs(array("main","website"));
            $websitepage = new WebsitePage($db);
            $fuser = new User($db);
            $arrayofblogs = $websitepage->fetchAll($website->id, 'DESC', 'date_creation', 5, 0, array('type_container'=>'blogpost', 'keywords'=>$keyword));
            if (is_numeric($arrayofblogs) && $arrayofblogs < 0)
            {
                print '<div class="error">'.$weblangs->trans($websitepage->error).'</div>';
            }
            elseif (is_array($arrayofblogs) && ! empty($arrayofblogs))
            {
                foreach($arrayofblogs as $blog)
                {
                    print '<div class="row justify-content-sm-center row-40">';
                    print '<div class="container blog-box centpercent" style="padding: 20px; transition: .3s all ease;">';
                                print '<a href="'.$blog->pageurl.'.php">';
                                print '<div class="post-boxed-img-wrap"><img src="'.($blog->image ? 'viewimage.php?modulepart=medias&file='.$blog->image : 'medias/image/'.$website->ref.'/calendar.svg"').'" alt="" width="120"></div>';
                                print '<div class="post-boxed-caption">';
                                print '<div class="post-boxed-title font-weight-bold">'.$blog->title.'</div>';
                                print '<ul class="list-inline list-inline-dashed text-uppercase">';
                                print '<li>'.dol_print_date($blog->date_creation, 'daytext', 'tzserver', $weblangs).'</li>';
                                $fuser->fetch($blog->fk_user_creat);
                                print '<li><span>by<span> <span class="text-primary">'.($fuser->firstname?$fuser->firstname:$fuser->login).'</span></span></li>';
                                print '</ul>';
                                print '</div>';
                                //includeContainer($blog->pageurl);
                                print '<span class="nohover">'.$blog->description.'</span>';
                                print '</a>';
                    print '</div>';
                    print '</div>';
                }
            }
            else
            {
                    print '<div class="row justify-content-sm-center row-40">';
                    print '<div class="container blog-box centpercent" style="padding: 20px; transition: .3s all ease;">';
                    print $weblangs->trans("NoArticlesFoundForTheKeyword", $keyword);
                    print '</div>';
                    print '</div>';
                
            }
            ?>
            </div>
        </section>

	</div>



	<!-- Footer -->
	<?php includeContainer('footer'); ?>
	
	
</div>


</body>
</html>
<?php // BEGIN PHP
$tmp = ob_get_contents(); ob_end_clean(); dolWebsiteOutput($tmp, "html", 379);
// END PHP ?>
